using System;
using Server.Mobiles;
using Server.Items;
using Server.Network;
using System.Collections;
using System.Collections.Generic;
using Server.ContextMenus;

namespace Server.Mobiles
{
	//[CorpseName( "an ostard corpse" )]
	public class DarkZostrich : BaseMount
	{
		[Constructable]
		public DarkZostrich() : this( 0.30 > Utility.RandomDouble() )
		{
		}

		[Constructable]
		public DarkZostrich( bool ostard ) : base( 
         (ostard) ? "a dark ostard" : "a dark zostrich", 
         (ostard) ? 0xD2 : 0xDA, (ostard) ? 0x3EA3 : 0x3EA4, 
         AIType.AI_Melee, FightMode.Closest, 10, 1, 0.2, 0.4 )
		{
         if ( ostard )
         {
            BaseSoundID = 0x270;
			   Hue = DarkElf.RandomDarkElfHairHue;
         }
         else
         {
            BaseSoundID = 0x275;
			   Hue = DarkElf.RandomDarkElfSkinHue;
         }

			SetStr( 1201, 1225 );
			SetDex( 151, 170 );
			SetInt( 251, 282 );

			SetHits( 1010, 1170 );
			SetMana( 60, 65 );//from Hiryu
			SetStam( 170, 270 );//from hiryu

			SetDamage( 22, 28 );//hiryu damage
			
			SetDamageType( ResistanceType.Physical, 0 );
			SetDamageType( ResistanceType.Cold, 50 );
			SetDamageType( ResistanceType.Energy, 50 );
			
			SetResistance( ResistanceType.Physical, 45, 55 );//used 5 over and 5 under what stratics posted
			SetResistance( ResistanceType.Fire, 25, 35 );
			SetResistance( ResistanceType.Cold, 65, 75 );
			SetResistance( ResistanceType.Poison, 25, 35 );
			SetResistance( ResistanceType.Energy, 65, 75 );

			SetSkill( SkillName.Wrestling, 90.1, 96.8 );
			SetSkill( SkillName.Tactics, 90.3, 99.3 );
			SetSkill( SkillName.MagicResist, 75.3, 90.0 );
			SetSkill( SkillName.Anatomy, 65.5, 69.4 );
			SetSkill( SkillName.Healing, 72.2, 98.9 );
			SetSkill( SkillName.AnimalLore, 65.5, 69.4 );
			SetSkill( SkillName.Veterinary, 72.2, 98.9 );
			
			Fame = 800;
			Karma = -1500;
			EmoteHue = Utility.RandomNeutralHue();

			Tamable = true;
			ControlSlots = 3;
			MinTameSkill = 105.1;
			VirtualArmor = 50;
			
			Container pack = Backpack;

			if ( pack != null )
				pack.Delete();

			pack = new StrongBackpack();
			pack.Movable = false;

			AddItem( pack );
		}

		public override int Meat{ get{ return 5; } }
		public override FoodType FavoriteFood{ get{ return FoodType.Meat | FoodType.Fish | FoodType.Eggs | FoodType.FruitsAndVegies; } }
		public override PackInstinct PackInstinct{ get{ return PackInstinct.Ostard; } }
		public override Poison PoisonImmune{ get{ return Poison.Lethal; } }
		public override bool IsNotScaredOfDeath{ get{ return true; } } //neutika pri malem poctu hp
		public override int Hides{ get{ return 10; } }
		public override HideType HideType{ get{ return HideType.Spined; } }
		
		public override bool CanAngerOnTame { get { return true; } }
		public override bool StatLossAfterTame{ get{ return true; } }
		// 		public override bool SubdueBeforeTame{ get{ return true; } } // Must be beaten into submission
		
		public override double GetControlChance( Mobile m )
		{
			if ( m.Skills[SkillName.AnimalTaming].Base < 105.1 )
			{
				m.SendMessage( "Nedokazes ovladat toto stvoreni." );
				return 0;
			}
			else
			{
				return 1.0;
			}
		}
		
		public override void OnThink() // TODO: Please make sure, if you got Bloody bandages, that CuSidhe can NOT get them.
		{
			this.BandageSelf();

			base.OnThink();
		}
		
		public override void OnGotMeleeAttack( Mobile attacker )
		{
			base.OnGotMeleeAttack( attacker );

			if ( this.IsBonded && 0.1 > Utility.RandomDouble() )
			{
				Effects.PlaySound( this.Location, this.Map, 0x207 );
				ZoogiVejce.EffectCircle( this.Location, this.Map, 4, 0x376A );
				
				foreach ( Mobile mobile in this.Map.GetMobilesInRange( this.Location, 4 ) )
				{
					if ( mobile == null || mobile.Deleted || mobile.Blessed || !mobile.Alive || !mobile.InLOS( this ) || mobile is BaseChampion )
						continue;
					
					if ( mobile is BaseCreature && !((BaseCreature)mobile).Controlled && !mobile.IsDeadBondedPet )
					{
						((BaseCreature)mobile).Pacify( this, DateTime.Now + TimeSpan.FromSeconds( 6.0 ) ); // TODO check
					}
				}
			}
			
			if ( 0.5 > Utility.RandomDouble() && this.Hits < ( this.HitsMax / 4 ) )
			{
				if ( !IsBeingDrained( attacker ) )
				{
					attacker.SendLocalizedMessage( 1070848 ); // You feel your life force being stolen away.
					BeginLifeDrain( attacker, this );
				}
			}
		}
		
		private static Hashtable m_Table = new Hashtable();

		public static bool IsBeingDrained( Mobile m )
		{
			return m_Table.Contains( m );
		}

		public static void BeginLifeDrain( Mobile m, Mobile from )
		{
			Timer t = (Timer)m_Table[m];

			if ( t != null )
				t.Stop();

			t = new InternalTimer( from, m );
			m_Table[m] = t;

			t.Start();
		}

		public static void DrainLife( Mobile m, Mobile from )
		{
			if ( m != null && from != null && !m.Deleted && !from.Deleted && m.Alive && from.Alive  )
			{
				if ( m.IsDeadBondedPet || from.IsDeadBondedPet )
			   {
				  EndLifeDrain( m );
				  return;
			   }
            
            int damageGiven = AOS.Damage( m, from, 20, 100, 0, 0, 0, 0 );
				from.FixedParticles( 0x376A, 9, 32, 5005, EffectLayer.Waist );
				from.PlaySound( 0x5C9 );
				
				if ( from is BaseCreature && ((BaseCreature)from).IsBonded )
					damageGiven = 100;

				from.Heal( damageGiven );
			}
			else
			{
				EndLifeDrain( m );
			}
		}

		public static void EndLifeDrain( Mobile m )
		{
			Timer t = (Timer)m_Table[m];

			if ( t != null )
				t.Stop();

			m_Table.Remove( m );

			m.SendLocalizedMessage( 1070849 ); // The drain on your life force is gone.
		}
		
		private class InternalTimer : Timer
		{
			private Mobile m_From;
			private Mobile m_Mobile;
			private int m_Count;

			public InternalTimer( Mobile from, Mobile m ) : base( TimeSpan.FromSeconds( 5.0 ), TimeSpan.FromSeconds( 5.0 ) )
			{
				m_From = from;
				m_Mobile = m;
            Priority = TimerPriority.OneSecond;
			}

			protected override void OnTick()
			{
				DrainLife( m_Mobile, m_From );

				if ( ++m_Count >= 6 )
					EndLifeDrain( m_Mobile );
			}
		}
		
		#region Pack Animal Methods
		public override bool OnBeforeDeath()
		{
         if ( 0.2 > Utility.RandomDouble() )
         {
            this.Emote( "* Cheating Death *" );
            this.Animate( 21, 6, 1, true, false, 0 );
            this.PlaySound( 628 );
            this.Hits = ( this.HitsMaxSeed / 3 );
            return false;
         }
         
         if ( !base.OnBeforeDeath() )
				return false;

			PackAnimal.CombineBackpacks( this );

			return true;
		}

		public override DeathMoveResult GetInventoryMoveResultFor( Item item )
		{
			return DeathMoveResult.MoveToCorpse;
		}

		public override bool IsSnoop( Mobile from )
		{
			if ( PackAnimal.CheckAccess( this, from ) )
				return false;

			return base.IsSnoop( from );
		}

		public override bool OnDragDrop( Mobile from, Item item )
		{
			if ( CheckFeed( from, item ) )
				return true;

			if ( PackAnimal.CheckAccess( this, from ) )
			{
				AddToBackpack( item );
				return true;
			}

			return base.OnDragDrop( from, item );
		}

		public override bool CheckNonlocalDrop( Mobile from, Item item, Item target )
		{
			return PackAnimal.CheckAccess( this, from );
		}

		public override bool CheckNonlocalLift( Mobile from, Item item )
		{
			return PackAnimal.CheckAccess( this, from );
		}

		public override void GetContextMenuEntries( Mobile from, List<ContextMenuEntry> list )
		{
			base.GetContextMenuEntries( from, list );

			PackAnimal.GetContextMenuEntries( this, from, list );
		}
		#endregion
		
		public DarkZostrich( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}
}
